/**
* \file: DummyMediaPlaybackStatus.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_DUMMYMEDIAPLAYBACKSTATUS_H
#define AAUTO_DUMMYMEDIAPLAYBACKSTATUS_H

#include <string>
#include <aauto/AditMediaPlaybackStatus.h>

namespace adit { namespace aauto {

class DummyMediaPlaybackStatusImpl;

class DummyMediaPlaybackStatus : public AditMediaPlaybackStatus
{
public:
    DummyMediaPlaybackStatus(uint8_t inSessionId, MessageRouter* inMessageRouter);

    ~DummyMediaPlaybackStatus();

    /**
     * @brief Set configuration for platform and AAuto-related items.
     *         All configurations must be called before init().
     * @param  inKey        The key string for configuration
     * @param  inValue      The actual value for configuration */
    void setConfigItem(std::string inKey, std::string inValue);

    /**
     * @brief Register callbacks to receive media playback status notifications.
     * @param   inCallbacks object implementing the callback interface */
    void registerCallbacks(IAditMediaPlaybackStatusCallbacks* inCallbacks);

    /**
     * @brief Initialize the endpoints.
     *      All configuration items must be set before calling this function.
     * @return true if initialization succeeds.
     *      false if fails. */
    bool init();

    /**
     * @brief  Shut down the endpoint and release allocated resources */
    void shutdown();

private:
    DummyMediaPlaybackStatusImpl* impl;
};


} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_DUMMYMEDIAPLAYBACKSTATUS_H */
